state:filter_interactions(function(i)
  return "This level does not allow interaction."
end)
if(tutorial_settings == nil) then
  tutorial_settings = {show = true}
end
local played_in_past = tutorial_settings.played
state:on_save(function(save)
  tutorial_settings.played = true
  save:set("tutorial_settings", tutorial_settings)
  tutorial_settings.played = played_in_past
end)
local set_hint_text = make_dynamic_hint(Hint.tutorial)
state:on_interface_render_lower(function(c)
  if not tutorial_settings.show then
    set_hint_text(nil)
    return
  end
  if state:is_at_start() then
    local width = resize.user_region.greater[0] - resize.user_region.lesser[0];
    if state:is_resize_tab_open() then
      set_hint_text("Follow the instructions to delete a column between the two sets of conveyors.")
    elseif width > 9 then
      set_hint_text("It looks like you expanded the level! Open the resize tab again to shrink it.")
    elseif width == 9 then
      set_hint_text("This level will not allow normal interactions, but unlocks a new feature: resizing levels. This feature allows you to change the size of levels to either give you more space to work with or condense a working factory to be smaller.\n\nFor this level, we need to shrink the region to bring together the two sets of conveyors. Open the resize tab by clicking on the arrows icon in the upper right corner.")
    else
      set_hint_text("Looks like you've got the hang of it!")
    end
  else
    set_hint_text(nil)
  end
end)
